
#pragma hdrstop
#include <condefs.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "fftmain.h"

//---------------------------------------------------------------------------
USEUNIT("..\src\fftmain.c");
USELIB("..\..\uspl.lib");
//---------------------------------------------------------------------------
#pragma argsused
/*---------------------------------------------------------------------------
Some important notes and issues regarding this program.
remember, the frequency of the sine wave you are generating
*must* be < sample_rate/2, or the waveform will be aliased.
The resolution of the fft in determining the frequency generated
is dependant on sample_rate/fft_size, therefore if you have a high
sample rate and a small fft size, the fft bins are so large that there
is a lot of error in determining the frequency of the sine wave.
---------------------------------------------------------------------------*/

int main(int argc, char **argv)
{
long sample_rate,fft_size;
float freq;

/* call is in the form
   fft_xxx freq samp_rate fft_size */

if (argc!=4)
{
  printf("Usage:\n");
  printf("%s frequency sample_rate fft_size\n",argv[0]);
  exit(-1);
}

/* get parameters */
sample_rate=atoi(argv[2]);
fft_size=atoi(argv[3]);
freq=atof(argv[1]);

return fftmain(sample_rate, fft_size, freq);


}

